### 11.2. 添加classpath依赖

Spring Boot提供很多"Starter POMs"，这能够让你轻松的将jars添加到你的classpath下。我们的示例程序已经在POM的partent节点使用了`spring-boot-starter-parent`。`spring-boot-starter-parent`是一个特殊的starter，它提供了有用的Maven默认设置。同时，它也提供了一个`dependency-management`节点，这样对于”blessed“依赖你可以省略version标记。

其他的”Starter POMs“简单的提供依赖，这些依赖可能是你开发特定类型的应用时需要的。由于正在开发一个web应用，我们将添加一个`spring-boot-starter-web`依赖-但在此之前，让我们看下目前所拥有的：
```shell
$ mvn dependency:tree
[INFO] com.example:myproject:jar:0.0.1-SNAPSHOT
```
`mvn dependency:tree`命令以树形表示来打印你的项目依赖。你可以看到`spring-boot-starter-parent`本身并没有提供依赖。编辑我们的pom.xml，并在parent节点下添加`spring-boot-starter-web`依赖：
```xml
<dependencies>
    <dependency>
        <groupId>org.springframework.boot</groupId>
        <artifactId>spring-boot-starter-web</artifactId>
    </dependency>
</dependencies>
```
如果再次运行`mvn dependency:tree`，你将看到现在有了一些其他依赖，包括Tomcat web服务器和Spring Boot自身。
